<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM – Open Source CRM application.
 * Copyright (C) 2014-2024 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

namespace Espo\Core\Select\AccessControl\Filters;

use Espo\Core\Select\AccessControl\Filter;
use Espo\Core\Select\Helpers\FieldHelper;
use Espo\Entities\User;
use Espo\Modules\Crm\Entities\Contact;
use Espo\ORM\Query\SelectBuilder as QueryBuilder;

class PortalOnlyContact implements Filter
{
    public function __construct(
        private User $user,
        private FieldHelper $fieldHelper
    ) {}

    public function apply(QueryBuilder $queryBuilder): void
    {
        $orGroup = [];

        $contactId = $this->user->get('contactId');

        if ($contactId) {
            if ($this->fieldHelper->hasContactField()) {
                $orGroup['contactId'] = $contactId;
            }

            if ($this->fieldHelper->hasContactsRelation()) {
                $queryBuilder
                    ->leftJoin('contacts', 'contactsAccess')
                    ->distinct();

                $orGroup['contactsAccess.id'] = $contactId;
            }

            if ($this->fieldHelper->hasParentField()) {
                $orGroup[] = [
                    'parentType' => Contact::ENTITY_TYPE,
                    'parentId' => $contactId,
                ];
            }
        }

        if ($this->fieldHelper->hasCreatedByField()) {
            $orGroup['createdById'] = $this->user->getId();
        }

        if (empty($orGroup)) {
            $queryBuilder->where(['id' => null]);

            return;
        }

        $queryBuilder->where(['OR' => $orGroup]);
    }
}
